import pennylane as qml
from pennylane import numpy as np
from math import pi
import os
from datetime import datetime
import optimizer


for n_qubits in range(5, 16):
    for n_layer in range(5, 16):

        dev_target = qml.device("default.qubit", wires=n_qubits)

        @qml.qnode(dev_target, interface="autograd", diff_method="backprop")
        def ansatz_target(params):

            k = 0
            for _ in range(n_layer):

                for j in range(n_qubits):
                    qml.CZ(wires=[j, (j + 1) % n_qubits])

                for j in range(n_qubits):
                    qml.RX(2 * params[k], wires=j)
                    k += 1

                for j in range(n_qubits):
                    qml.RY(2 * params[k], wires=j)
                    k += 1

            measurements = []
            for idx in range(n_qubits - 1):
                obs = (
                    qml.PauliX(idx) @ qml.PauliX(idx + 1)
                    + qml.PauliY(idx) @ qml.PauliY(idx + 1)
                    + qml.PauliZ(idx) @ qml.PauliZ(idx + 1)
                )
                measurements.append(qml.expval(obs))
            return measurements

        n_params_target = 2 * n_layer * n_qubits


        mask_filename = f"Frozenmask_90/high_count_nodes_qubits{n_qubits}_layers{n_layer}_90.npy"
        if not os.path.exists(mask_filename):
            print(f"[Warning] mask file not found: {mask_filename}")
            continue
        s2mask_gd_0 = np.load(mask_filename)


        gamma = 1.0 / (100.0) ** 0.5
        iteration = 100
        n_time = 1
        lr = 0.01
        n_check = 20

        circuit_name_target = f"gd_q{n_qubits}_l{n_layer}"

        optimizer.gd_gaussian(
            ansatz_target,
            circuit_name_target,
            n_qubits,
            n_params_target,
            gamma,
            1,
            0, 0,
            lr,
            iteration,
            n_time,
            n_check,
            s2mask_source=s2mask_gd_0
        )

        print(f"### Done (q={n_qubits}, l={n_layer}) ###\n")
